#!/usr/bin/perl
# mailcall.pl - mail submission script for MailCall(tm)
# (c) 2000 by Synergetic Data Systems Inc.  All rights reserved.
# Licensed exclusively for use with MailCall.
# Modified to use the IO::Socket::INET for greater perl compatibility

require IO::Socket::INET;

# set $log = 1 to get a stream log of connection activity
$log = 1;

if ( $ARGV[0] eq "" ) { die "Usage: mailcall.pl filename\n"; }

if (! open(SUBMISSION,$ARGV[0]) ) {
  if ($log) { print "Can't open submission file $ARGV[0]!\n"; }
  exit 1;
}

# get smtp parameters
chop($basedir=`dirname $0`);
$inifile="$basedir/mailcall.ini";
if (! open(INI,$inifile) ) {
  if ($log) { print "Can't open $basedir/mailcall.ini file!\n"; }
  exit 1;
}
while (<INI>) {
  $_ =~ tr/\r\n//d;
  if ( index($_,"server=") == 0 ) { $server = substr($_,7); }
  if ( index($_,"from=") == 0 ) { $dfrom = substr($_,5); }
}
close (INI);

if ( index($server,".") < 0 ) {
  if ($log) { print "Incomplete server= in mailcall.ini!\n"; }
  exit 1;
}

# get this host id
chop($hostname=`hostname`);

# setup socket (scalar s is handle)
#$af = 2;
#$stream = 1;
#$sockaddr = 'S n a4 x8';
#($name,$aliases,$proto) = getprotobyname('tcp');
#($name,$aliases,$type,$len,$hostip) = gethostbyname($hostname);
#$port=25;
#($name,$aliases,$type,$len,$servip) = gethostbyname($server);
#$hostsock=pack($sockaddr,$af,0,$hostip);
#$servsock=pack($sockaddr,$af,$port,$servip);

#if ( socket(sck,2,1,$proto) ) {
#  if ($log) { print "Socket established.\n"; }
#}
#else {
#  if ($log) { print "No socket established - $!\n"; }
#  exit 2;
#}

#if (bind(sck,$hostsock)) {
#  if ($log) { print "Bind to local port\n"; }
#}
#else {
#  if ($log) { print "Bind failed - $!\n"; }
#  exit 2;
#}

#if (connect(sck,$servsock)) {
#  if ($log) { print "Connected to smtp server\n"; }
#}
#else {
#  if ($log) { print "Failed to connect to smtp server - $!\n"; }
#  exit 2;
#}

if ( $sck=IO::Socket::INET->new("$server:25") ) {
	if ($log) { print "Connected to server $server\n"; }
} else {
	if ($log) { print "Failed to connect to $server ($!)\n"; }
	exit 2;
}

# start processing submission file
$section=0;

while ( <SUBMISSION> ) {
 
 # first, slurp up and parse header info
 if ( $section == 0 ) {
   $line = $_;
   $line =~ tr/\r\n//d;
   if ($line eq "") { $section = 1 }
   if ( index($line,"To: ") == 0) { $to = substr($line,4); }
   if ( index($line,"From: ") == 0) { $from = substr($line,6); }
   if ( index($line,"Cc: ") == 0) { $cc = substr($line,4); }
   if ( index($line,"Bcc: ") == 0) {
      $bcc = substr($line,5);
      $_ = "";
   }

   if ( index($line,"X-login: ") == 0 ) {
      $login = substr($line,9);
      $_ = "";
   }

   if ( index($line,"X-pswd: ") == 0 ) {
      $pswd = substr($line,8);
      $_ = "";
   }

   $header = "$header$_";
 }

 # with header info, connect to mail server
 if ( $section == 1 ) {
   select($sck); $|=1; select(STDOUT);
   $x=<$sck>; 
   if ($log) { print "server: $x"; }

   # May need to drain 220- responses until 220<space> response
   while ($x =~ /^220-/) {
      $x=<$sck>;
      if ($log) { print "server: $x"; }
   }
   
   if ( $x !~ /^220 / ) { exit 3; }


   # try esmtp first
   $send="EHLO $hostname\r\n";
   print $sck $send;
   if ($log) { print "client: $send"; }
   $x=<$sck>;
   if ($log) { print "server: $x"; }

   if ( $x !~ /^250/ ) {
      $send="HELO $hostname\r\n";   
      print $sck $send;
      if ($log) { print "client: $send"; }
      $x=<$sck>;
      if ($log) { print "server: $x"; }
   }

   # drain ESMTP responses in case server ignores our HELO
   while ($x =~ /^250-/) {
      $x=<$sck>;
      if ($log) { print "server: $x"; }

      if ( $x =~ /-[Aa][Uu][Tt][Hh]/ ) {
         if ( $x =~ /[Ll][Oo][Gg][Ii][Nn]/ ) {
             $authlogin=1;
         }
      }

   }


   # auth login?
   if ( $authlogin && $login && $pswd ) {
      $send="AUTH LOGIN\r\n";
      print $sck $send;
      if ($log) { print "client: $send"; }
      $x=<$sck>;
      if ($log) { print "server: $x"; }

      if ( $x =~ /^334/ ) {
         $send="$login\r\n";
         print $sck $send;
         if ($log) { print "client: $send"; }
         $x=<$sck>;
         if ($log) { print "server: $x"; }

         $send="$pswd\r\n";
         print $sck $send;
         if ($log) { print "client: $send"; }
         $x=<$sck>;
         if ($log) { print "server: $x"; }

         if ( $x !~ /^2/ ) { exit 3; }

      }
   }


   # default 'from' address
   if ($from !~ /.*@.*\..*/ ) { $from=$dfrom }

   $from =~ s/^.*<//;
   $from =~ s/>.*$//;

   $send="MAIL FROM: <$from>\r\n";
   print $sck $send;
   if ($log) { print "client: $send"; }
   $x=<$sck>;
   if ($log) { print "server: $x"; }
   if ( $x !~ /^250/ ) { exit 3; }

   @tos = split(',',"$to,$cc,$bcc");
   foreach $to (@tos) {
     $to =~ s/^.*<//;
     $to =~ s/>.*$//;
     if ( index($to,"@") != -1) {
       $send="RCPT TO: <$to>\r\n";
       print $sck $send;
       if ($log) { print "client: $send"; }
       $x=<$sck>;
       if ($log) { print "server: $x"; }
       if ( $x !~ /^25/ ) { exit 3; }
     }
   }

   $send="DATA\r\n";
   print $sck $send;
   if ($log) { print "client: $send"; }
   $x=<$sck>;
   if ($log) { print "server: $x"; }
   if ( $x !~ /^354/ ) { exit 3; }

   print $sck $header;
   if ($log) { print "client: sending message data.\n"; }
   $section = 2;

 }

 if ($section == 2) {
 # send message body

   if ( substr($_,0,1) eq "." ) {
      $_=".$_";
   }

   print $sck $_;

 }


}

$send=".\r\n";
print $sck $send;
if ($log) { print "client: end of data.\n"; }
$x=<$sck>;
if ($log) { print "server: $x"; }
if ( $x !~ /^250/ ) { exit 3; }

$send="QUIT\r\n";
print $sck $send;
if ($log) { print "client: $send"; }
$x=<$sck>;
if ($log) { print "server: $x"; }
close($sck);
close(SUBMISSION);


